<?php
// Este código debe usarse con cuidado, pues sobreescribe los códigos QR de los CFDIs
	include_once ("../utilerias/valida_Receive.php"); 
	require('../utilerias/clasePdf_2022.php');
get_registros();

function get_registros(  ) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    /*$sql    = "SELECT  
    A.foliofiscal, A.empresa_id, A.cliente_id, A.sellodigital, A.total, 
    A.folio, A.serie, 
    E.rfc AS empresa_rfc,  
    C.rfc AS cliente_rfc 
    FROM factura  A 
    LEFT JOIN empresa E ON (A.empresa_id = E.id ) 
    LEFT JOIN cliente C ON (A.cliente_id = C.id ) 
    WHERE 1 "; */

    $sql = "
    SELECT A.foliofiscal, A.empresa_id, A.cliente_id, A.sellodigital, A.total, A.folio, A.serie, E.rfc AS empresa_rfc, C.rfc AS cliente_rfc, A.fecha FROM factura A LEFT JOIN empresa E ON (A.empresa_id = E.id ) LEFT JOIN cliente C ON (A.cliente_id = C.id ) WHERE A.total >= 50000 AND A.status LIKE 'Timbr%' AND A.fecha NOT LIKE '2021%' AND A.fecha NOT LIKE '2020%' AND A.fecha NOT LIKE '2019%' AND A.fecha NOT LIKE '2018%'
    ";

    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    
$zip = new ZipArchive();
    $return_arr = array();
    if (!empty($datos)) {
        foreach($datos as $k=>$v) {  
            /*$return_arr[] = array(
            'id'            => $datos[$k]["id"], 
            'nombre'   => $datos[$k]["nombre"] 
            );
            */

	        $uuid 		= $datos[$k]["foliofiscal"];
	        $empresa_rfc= $datos[$k]["empresa_rfc"];
	        $cliente_rfc= $datos[$k]["cliente_rfc"];
	        $total      = $datos[$k]["total"];
	        $folio      = $datos[$k]["folio"];
	        $serie      = $datos[$k]["serie"];
	        $sellocfd   = $datos[$k]["sellodigital"];
	        $fecha      = $datos[$k]["fecha"];

            /*
	        echo "<br>=> ".$folio. "-   ".$serie. " = ".$empresa_rfc;
	        $ultimos8 = "";
	        if (strlen($sellocfd)>10)
	        	$ultimos8 = substr($sellocfd, -8);

	        $contenido_qr = "https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=".$uuid."&re=".$empresa_rfc."&rr=".$cliente_rfc."&tt=".$total."&fe=".$ultimos8;

	        // Crear el QR
	        $file = "../../panel/LALL910531QW3/cfdi/factura/cfdi/"."Factura_LALL910531QW3_".$folio."_".$serie.".png";
			//include("crea_qr.php");
	        recibe_datos($file,  $contenido_qr, "code" );
	        */
	
	    /*        
	        $datos_factura = get_facturapago_imprime_JSON($folio, $serie);
	        imprime_docto($datos_factura);
	    */
	    


//$zip->open('2022.zip', ZipArchive::OVERWRITE);
//echo "Fecha: ".substr($fecha, 0, 4);
if (substr($fecha, 0, 4)== "2022"){
    
    $zip->open('2022.zip', ZipArchive::CREATE);
    $options = array('' => '2022/', 'remove_all_path' => TRUE);
    $zip->addGlob('../../panel/LALL910531QW3/cfdi/factura/pdf/'.'Factura_LALL910531QW3_'.$folio."_.pdf", 0, $options);
    $zip->addGlob('../../panel/LALL910531QW3/cfdi/factura/cfdi/'.'Factura_LALL910531QW3_'.$folio."_.xml", 0, $options);
    $zip->close();
} 


if (substr($fecha, 0, 4)== "2023"){
    
    $zip->open('2023.zip', ZipArchive::CREATE);
    $options = array('' => '2022/', 'remove_all_path' => TRUE);
    $zip->addGlob('../../panel/LALL910531QW3/cfdi/factura/pdf/'.'Factura_LALL910531QW3_'.$folio."_.pdf", 0, $options);
    $zip->addGlob('../../panel/LALL910531QW3/cfdi/factura/cfdi/'.'Factura_LALL910531QW3_'.$folio."_.xml", 0, $options);
    $zip->close();
} 

if (substr($fecha, 0, 4)== "2024"){
    
    $zip->open('2024.zip', ZipArchive::CREATE);
    $options = array('' => '2022/', 'remove_all_path' => TRUE);
    $zip->addGlob('../../panel/LALL910531QW3/cfdi/factura/pdf/'.'Factura_LALL910531QW3_'.$folio."_.pdf", 0, $options);
    $zip->addGlob('../../panel/LALL910531QW3/cfdi/factura/cfdi/'.'Factura_LALL910531QW3_'.$folio."_.xml", 0, $options);
    $zip->close();
} 


//$zip->addFile('fonts/Monoton/Monoton-Regular.ttf', 'Monoton-Regular.ttf');
//$zip->addFile('Factura_LALL910531QW3_'.$folio."_.pdf", 'Factura_LALL910531QW3_'.$folio."_.pdf");
 


        }
    }
    //echo json_encode($return_arr);
}


function coprime_file(){
    $zip = new ZipArchive();
    $zip->open('compressed/font_files.zip', ZipArchive::CREATE);
     
    $zip->addFile('fonts/Monoton/Monoton-Regular.ttf', 'Monoton-Regular.ttf');
    $zip->addFile('fonts/Monoton/OFL.txt', 'license.txt');
     
    $zip->close();
}


function get_facturapago_imprime_JSON( $folio, $serie ) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    
    $sql    = "
        SELECT A.id as idFactura, 
        A.cliente_id, A.empresa_id, 
        B.razon_social AS cliente_razonsocial, B.rfc AS cliente_rfc,  
        B.id as idCliente, B.rfc AS cliente_rfc, B.cp AS cliente_cp, 
         
        A.cfdi_version, A.folio, A.serie,  A.fecha, A.observaciones, 
        A.subtotal, A.total, A.montol,  A.formapago, A.metodopago, A.moneda, 

        A.condicionespago,  A.foliofiscal, A.banconum, 
        A.emision, A.sellodigital, A.sellosat,  A.cadenaoriginal, A.csd, A.csdpac, 

        C.razon_social as empresa_nombre, C.rfc as empresa_rfc, C.curp AS empresa_curp, 
        C.id as idEmpresa,  C.razon_social As empresa_razonsocial, C.cp AS empresa_cp, 
        C.registropatronal AS empresa_registropatronal, C.riesgotrabajo AS empresa_riesgotrabajo, 
        
        C.regimenfiscal AS empresa_regimenfiscal_clave, 
        RF.nombre AS empresa_regimenfiscal_nombre, 
        B.regimen AS cliente_regimenfiscal_clave,
        RB.nombre AS cliente_regimenfiscal_nombre,  


        A.cfdiuso ,  A.cfditipocambio,  A.cfdiclaveconfirmacion,  A.cfdidescuento, 
        A.cfdi_iva_traslado,  A.cfdi_ieps_traslado,   A.cfdi_iva_retenido,   A.cfdi_isr_retenido, 

        A.rfcemisorctaord, A.nombancoordext, A.ctaordenante, 
        A.pagado, A.tipo, A.tipo2,  A.iniciales, A.usuario,   A.status, 

        D.id as idCFDI,       D.nombre as nombreCFDI, D.clave as claveCFDI, 
        E.id as idFormaPago,  E.nombre as nombreFP, E.clave as claveFP, 
        F.id as idMetodoPago, F.nombre as nombreMP, F.clave as claveMP, 
        G.id as idMoneda,  G.nombre as nombreMoneda, G.clave as claveMoneda, 

        /* Añadidos, 19 de Marzo 2023 */
        ED.calle AS e_calle,
        ED.cp  AS e_cp,
        ED.localidad  AS e_localidad,
        /*ED.ciudad AS e_ciudad, */
        ED.estado  AS e_estado, 
        /*ED.email AS e_email, */
        ED.pais  AS e_pais, 
        ED.colonia  AS e_colonia, 
        ED.nointerior  AS e_nointerior, 
        ED.noexterior  AS e_noexterior, 
        ED.status  AS e_status, 

        CD.calle AS c_calle,
        CD.cp  AS c_cp,
        CD.localidad  AS c_localidad,
        CD.ciudad AS c_ciudad, 
        CD.estado  AS c_estado, 
        /*CD.email AS c_email, */
        CD.pais  AS c_pais, 
        CD.colonia  AS c_colonia, 
        CD.nointerior  AS c_nointerior, 
        CD.noexterior  AS c_noexterior, 
        CD.status  AS c_status,

        EL.nombre AS logo_nombre,
        EF.color1 AS formato_color1, EF.color2 AS formato_color2, EF.color3 AS formato_color3 

        FROM factura A  
        LEFT JOIN cliente B ON A.cliente_id = B.id 
        LEFT JOIN empresa C ON A.empresa_id = C.id 
        LEFT JOIN cfdiuso D ON A.cfdiuso = D.clave 
        LEFT JOIN metodopago F ON A.metodopago = F.clave 
        LEFT JOIN formapago E ON  A.formapago = E.clave 
        LEFT JOIN moneda G ON  A.monedapago = G.clave  
        LEFT JOIN cat_regimenfiscal RF ON  RF.clave = C.regimenfiscal 
        LEFT JOIN cat_regimenfiscal RB ON  RB.clave = B.regimen 

        LEFT JOIN empresa_direccion ED ON ( C.id = ED.empresa_id ) 
        LEFT JOIN cliente_direccion CD ON ( B.id = CD.cliente_id ) 

        LEFT JOIN empresa_logos   EL  ON ( C.id = EL.empresa_id) 
        LEFT JOIN empresa_formato EF  ON ( C.id = EF.empresa_id) 
        
    
        WHERE A.folio = ". $folio."   LIMIT 1 ";

        // Advice. Added LEFT JOIN to JOIN querys
    $cfdi  = SQL_MultiFetch ($pdo, $sql, null); 
    

    
    // JOIN facturarelaciona FRE ON (FRE.folio = A.folio AND FRE.serie LIKE A.serie )
    $sqlrela = "SELECT 
        FRE.folio_sustituido AS folio_sustituido, FRE.serie_sustituido AS serie_sustituido, FRE.foliofiscal AS foliofiscal_sustituido   
        FROM facturarelaciona FRE 
        
        WHERE FRE.folio = ".$folio." AND FRE.serie LIKE '".$serie."' ";
        $cfdi_relaciona = SQL_MultiFetch ($pdo, $sqlrela, null); 
        

    $sqldeta = "SELECT 
        A.folio, A.id, A.empresa_id, A.cliente_id, A.serie, A.facturaid, A.productoid, A.cantidad, 
        A.punitario, A.total, A.descripcion, A.unidadm, A.claveprodserv, A.numeroidentificacion, 
        A.claveunidad, A.iva_traslado_tasa, A.iva_traslado_factor, A.iva_traslado_importe, 
        A.iva_traslado_impuesto, A.ieps_traslado_tasa, A.ieps_traslado_factor, A.ieps_traslado_importe, 
        A.ieps_traslado_impuesto, A.iva_retenido_tasa, A.iva_retenido_factor, A.iva_retenido_importe, 
        A.iva_retenido_impuesto, A.isr_retenido_tasa, A.isr_retenido_factor, A.isr_retenido_importe, 
        A.isr_retenido_impuesto, A.objetoimp  
        FROM facturadetalle A 
        WHERE A.facturaid = ".$folio." AND A.serie LIKE '".$serie."' ";
        //C.clienteid = " . $clienteid . " AND C.empresaid = ". $empresaid. " AND C.serie LIKE '".$serie."' ";
    $cfdi_detalle = SQL_MultiFetch ($pdo, $sqldeta, null); 
    //echo "SQL: ".$sqldeta; 
    //echo "________________________________________";
    //print_r($cfdi_detalle);


        $objeto = new stdClass();
        // Elemento 1. Cabecera
        $objeto->serie      = $cfdi[0]["serie"]; 
        $objeto->folio      = $cfdi[0]["folio"]; 
        $objeto->fecha      = $cfdi[0]["fecha"];   
        $objeto->moneda     = $cfdi[0]["moneda"];   
        $objeto->tipo       = $cfdi[0]["tipo"]; 
        $objeto->subtotal   = $cfdi[0]["subtotal"]; 
        //$objeto->descuento  = $cfdi[0]["descuento"]; 
        $objeto->total      = $cfdi[0]["total"]; 
        $objeto->montol     = $cfdi[0]["montol"]; 
        $objeto->foliofiscal= $cfdi[0]["foliofiscal"]; 
        $objeto->csd        = $cfdi[0]["csd"]; 
        $objeto->csdpac     = $cfdi[0]["csdpac"];  //  add
        $objeto->emision    = $cfdi[0]["emision"]; 
        $objeto->sellodigital= $cfdi[0]["sellodigital"]; 
        $objeto->sellosat   = $cfdi[0]["sellosat"]; 
        $objeto->cadenaoriginal= $cfdi[0]["cadenaoriginal"]; 
        $objeto->status     = $cfdi[0]["status"]; 
        $objeto->empresa_razonsocial= $cfdi[0]["empresa_razonsocial"]; 
        $objeto->empresa_rfc        = $cfdi[0]["empresa_rfc"]; 
        $objeto->cliente_razonsocial= $cfdi[0]["cliente_razonsocial"]; 
        $objeto->cliente_rfc        = $cfdi[0]["cliente_rfc"]; 
        $objeto->cliente_cp         = $cfdi[0]["cliente_cp"]; 
        $objeto->uso_clave  = $cfdi[0]["claveCFDI"]; 
        $objeto->uso_nombre = $cfdi[0]["nombreCFDI"]; 

        $objeto->cfdi_iva_traslado  = $cfdi[0]["cfdi_iva_traslado"]; 
        $objeto->cfdi_ieps_traslado = $cfdi[0]["cfdi_ieps_traslado"]; 
        $objeto->cfdi_iva_retenido  = $cfdi[0]["cfdi_iva_retenido"]; 
        $objeto->cfdi_isr_retenido  = $cfdi[0]["cfdi_isr_retenido"]; 

        // Adicionales al 19 de MArzo 2023 -> Se agrega esta parte de Acá
        $objeto->empresa_regimenfiscal_clave  = $cfdi[0]["empresa_regimenfiscal_clave"];  
        $objeto->empresa_regimenfiscal_nombre = $cfdi[0]["empresa_regimenfiscal_nombre"]; 
        $objeto->cliente_regimenfiscal_clave  = $cfdi[0]["cliente_regimenfiscal_clave"];  
        $objeto->cliente_regimenfiscal_nombre = $cfdi[0]["cliente_regimenfiscal_nombre"];  
        $objeto->observaciones      = $cfdi[0]["observaciones"];
        $objeto->empresa_cp         = $cfdi[0]["empresa_cp"];
        $objeto->formapago_nombre   = $cfdi[0]["nombreFP"];
        $objeto->formapago_clave    = $cfdi[0]["claveFP"];
        $objeto->metodopago_nombre   = $cfdi[0]["nombreMP"];
        $objeto->metodopago_clave    = $cfdi[0]["claveMP"];

        $objeto->e_calle     = $cfdi[0]["e_calle"];
        $objeto->e_cp        = $cfdi[0]["e_cp"];
        $objeto->e_localidad = $cfdi[0]["e_localidad"];
        //$objeto->e_ciudad    = $cfdi[0]["e_ciudad"];
        $objeto->e_estado    = $cfdi[0]["e_estado"];
        $objeto->e_pais      = $cfdi[0]["e_pais"];
        $objeto->e_colonia   = $cfdi[0]["e_colonia"];
        $objeto->e_nointerior= $cfdi[0]["e_nointerior"];
        $objeto->e_noexterior= $cfdi[0]["e_noexterior"];
        //$objeto->e_pais     = $cfdi[0]["e_pais"];

        $objeto->c_calle     = $cfdi[0]["c_calle"];
        $objeto->c_cp        = $cfdi[0]["c_cp"];
        $objeto->c_localidad = $cfdi[0]["c_localidad"];
        $objeto->c_ciudad    = $cfdi[0]["c_ciudad"];
        $objeto->c_estado    = $cfdi[0]["c_estado"];
        $objeto->c_pais      = $cfdi[0]["c_pais"];
        $objeto->c_colonia   = $cfdi[0]["c_colonia"];
        $objeto->c_nointerior= $cfdi[0]["c_nointerior"];
        $objeto->c_noexterior= $cfdi[0]["c_noexterior"];

        // Configuraciones
        $objeto->logo_nombre    = $cfdi[0]["logo_nombre"];
        $objeto->formato_color1 = $cfdi[0]["formato_color1"];
        $objeto->formato_color2 = $cfdi[0]["formato_color2"];
        $objeto->formato_color3 = $cfdi[0]["formato_color3"];
         

        // RElacionados 
        if (!empty($cfdi_relaciona)){
            foreach ($cfdi_relaciona as $k => $v) { 
                $objeto->relacionados[]= array ( 
                    "folio_sustituido"      => $cfdi_relaciona[$k]["folio_sustituido"],
                    "serie_sustituido"      => $cfdi_relaciona[$k]["serie_sustituido"], 
                    "foliofiscal_sustituido"=> $cfdi_relaciona[$k]["foliofiscal_sustituido"] 
                 );               

            }
        }
        
        if (!empty($cfdi_detalle)){
            foreach ($cfdi_detalle as $k => $v) {  
                $objeto->conceptos[]= array ( 
                    "cantidad"      => $cfdi_detalle[$k]["cantidad"],
                    "valorunitario" => $cfdi_detalle[$k]["punitario"], 
                    "importe"       => $cfdi_detalle[$k]["total"], 
                    "descripcion"   => $cfdi_detalle[$k]["descripcion"],
                    "unidad"        => $cfdi_detalle[$k]["unidadm"],
                    "claveprodserv" => $cfdi_detalle[$k]["claveprodserv"],
                    "numeroidentificacion"=> $cfdi_detalle[$k]["numeroidentificacion"],
                    "claveunidad"   => $cfdi_detalle[$k]["claveunidad"],

                    "iva_traslado_tasa"     => $cfdi_detalle[$k]["iva_traslado_tasa"], 
                    "iva_traslado_factor"   => $cfdi_detalle[$k]["iva_traslado_factor"], 
                    "iva_traslado_importe"  => $cfdi_detalle[$k]["iva_traslado_importe"], 
                    "iva_traslado_impuesto" => $cfdi_detalle[$k]["iva_traslado_impuesto"], 

                    "ieps_traslado_tasa"     => $cfdi_detalle[$k]["ieps_traslado_tasa"], 
                    "ieps_traslado_factor"   => $cfdi_detalle[$k]["ieps_traslado_factor"], 
                    "ieps_traslado_importe"  => $cfdi_detalle[$k]["ieps_traslado_importe"], 
                    "ieps_traslado_impuesto" => $cfdi_detalle[$k]["ieps_traslado_impuesto"], 

                    "iva_retenido_tasa"     => $cfdi_detalle[$k]["iva_retenido_tasa"], 
                    "iva_retenido_factor"   => $cfdi_detalle[$k]["iva_retenido_factor"], 
                    "iva_retenido_importe"  => $cfdi_detalle[$k]["iva_retenido_importe"], 
                    "iva_retenido_impuesto" => $cfdi_detalle[$k]["iva_retenido_impuesto"], 

                    "isr_retenido_tasa"     => $cfdi_detalle[$k]["isr_retenido_tasa"], 
                    "isr_retenido_factor"   => $cfdi_detalle[$k]["isr_retenido_factor"], 
                    "isr_retenido_importe"  => $cfdi_detalle[$k]["isr_retenido_importe"], 
                    "isr_retenido_impuesto" => $cfdi_detalle[$k]["isr_retenido_impuesto"], 

                    "objetoimp"     => $cfdi_detalle[$k]["objetoimp"]
                );               

            }
        }

    //echo json_encode($objeto);
    return json_encode($objeto);
}





    // CREA QR =============================================================
    // Funciones opcionales ================================================
    function recibe_datos($directorio, $datos, $prefijo){ 
        //$archivo = $PNG_TEMP_DIR."code_".$id.'.png';

        //$archivo = $prefijo."_".$id.'.png';

        $matrixPointSize = 5; // $matrixPointSize = 5; 
        $errorCorrectionLevel = 'M'; // array('L','M','Q','H' 

        $PNG_TEMP_DIR = dirname(__FILE__).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;
        //echo "Directorio: ".$PNG_TEMP_DIR;
        $PNG_WEB_DIR = '../dossier/';
        //$directorio =  '../dossier/';;
        create_qr($directorio, $datos, $matrixPointSize, $errorCorrectionLevel);
    }


    // Función crear Quick Response
    function create_qr($directorio, $datos, $matrixPointSize, $errorCorrectionLevel){ 
        //Incluye la librería
        include_once "../tools/phpqrcode/qrlib.php"; 
        //ofcourse we need rights to create temp dir
        /*
        if (!file_exists($PNG_TEMP_DIR))
            mkdir($PNG_TEMP_DIR);
            */
        //echo "Dire: ".$directorio; 
        //if (!file_exists($directorio))
        //    mkdir($directorio);

        QRcode::png($datos, $directorio, $errorCorrectionLevel, $matrixPointSize, 2); 
      
        //display generated file
        //echo '<img src="'.$directorio.basename($archivo).'" />';  // <hr/>
    }


function imprime_docto ($datos){
	//include_once ("../utilerias/valida_Receive.php"); 
	//require('../utilerias/clasePdf_2022.php');
	$sizeHoja 	= "LETTER";
	$aline_Hoja = "P";
	$pdf = new PDF_Invoice( $aline_Hoja, 'mm', $sizeHoja );
	$pdf->AddPage(); 
	
    // Recupero el JSON enviado
    //$datos = $_POST["datos"];
    $datos = json_decode($datos);   
    
    echo "<h3 style = 'color:blue'>Factura $datos->folio, $datos->fecha</h3>";
    //print_r($datos);

    $color_r = 255; $color_g = 0; $color_b = 0;
    $color1 = 0; $color2 = 0; $color3 = 0;
    //$tipoletra = "Arial";
    $tipoletra = "Arial"; 
    $imagenFondo = false;
    //$logotipo = "../config/tracto.jpg";
    $logotipo = $datos->logo_nombre; 
    $color_r = $datos->formato_color1; $color_g = $datos->formato_color2; $color_b = $datos->formato_color3;


// Se puede implementar funcion ************************************
	$condicionespago = 0;
	if ($condicionespago =="c15") {
		$condicionespago = utf8_decode("Crédito 15 días");
	}
	if ($condicionespago =="c30") {
		$condicionespago = utf8_decode("Crédito 30 días");
	}
	if ($condicionespago =="c45") {
		$condicionespago = utf8_decode("Crédito 45 días");
	}


	$x1= 0; $y1=0; $x2=0; $y2=0;
    
	if (($aline_Hoja =="P")and ($sizeHoja="LETTER")) { //Jasser  Formato 
		$linea1X1= 10; $linea1Y1=43; $linea1X2=200; $linea1Y2=43;
	    $linea2X1= 10; $linea2Y1=72; $linea2X2=200; $linea2Y2=72;
	    $posicionemisorY=45; $posicionemisorX=5;
	    $posicionreceptorY=10; $posicionreceptorX=40;
	    $posicionRegimenx = 108; $posicionRegimeny= 40;
	    $posicionexpedicionX = 165; $posicionexpedicionY=44;
	    $subtotalmontonumposx= 182; $subtotalmontonumposy=190;
	    $subtotalmontoconposx= 150; $subtotalmontoconposy=190;
	    $subtituloX=10; $subtituloY=75;
	    $cmX1=10; $cmX2=195; $cmY1=78; $cmY2=-13;
	    $logox1 = 5; $logoy1=10; $logosize=40; //5-> 10 Sept. 28
	    $logoFondox = 77; $logoFondoy = 150; $logoFondosize = 80; //60, 105, 200
	    $fcconstantealtura = 29; $fcc2 = 80; $fcv1 = 70; $fcalt = 6; $fcsizefont = 8;
	    $qrx=165; $qry=220; $qrprof = -140;
	    $temporairex=70; $temporairey= 190;
	    $firmax = 9; $firmay = 260;
	    $detallex=10; $detalley =97; $detalleconst=90; $detalleseparacion= 0;
	    $tituloxx = 165; $tituloxy =65;

	   	$cx1_1=10; $cx1_2=130; $cx1_3=198; $cx1_4=-22;
		$cx2_2 = 20; $cx2_3 = 190;
		$cx3_1=10; $cx3_2=160; $cx3_3=226; $cx3_4=-24;
		$cx4_2 = 10; $cx4_3 = 218;
		$cx5_1=10; $cx5_2=160; $cx5_3=238; $cx5_4=-24;
		$cx6_2 = 10; $cx6_3 = 218+13;
		$cx7_1=10; $cx7_2=160; $cx7_3=250; $cx7_4=-24;
		$cx8_2 = 10; $cx8_3 = 243;
	}  else if (($aline_Hoja =="L")and ($sizeHoja="LETTER")) {
	    $linea1X1= 10; $linea1Y1=43; $linea1X2=200; $linea1Y2=43;
	    $linea2X1= 10; $linea2Y1=72; $linea2X2=200; $linea2Y2=72;
	    $posicionemisorY=45; $posicionemisorX=5;
	    $posicionreceptorY=10; $posicionreceptorX=40;
	    $posicionRegimenx = 108; $posicionRegimeny= 40;
	    $posicionexpedicionX = 165; $posicionexpedicionY=44;
	    $subtotalmontonumposx= 185; $subtotalmontonumposy=160;
	    $subtotalmontoconposx= 145; $subtotalmontoconposy=160;
	    $subtituloX=10; $subtituloY=75;
	    $cmX1=10; $cmX2=195; $cmY1=78; $cmY2=-13;
	    $logox1 = 8; $logoy1=8; $logosize=33;
	    $logoFondox = 60; $logoFondoy = 105; $logoFondosize = 100;
	    $fcconstantealtura = 29; $fcc2 = 80; $fcv1 = 70; $fcalt = 6; $fcsizefont = 9;
	    $qrx=225; $qry=160; $qrprof = -140;
	    $temporairex=70; $temporairey= 190;
	    $firmax = 9; $firmay = 260;
	    $detallex=10; $detalley =97; $detalleconst=55; $detalleseparacion = 60;
	    $tituloxx = 165; $tituloxy =65;

		$cx1_1=10; $cx1_2=140; $cx1_3=172; $cx1_4=-22; 		//$cx1_1, $cx1_2, $cx1_3, $cx1_4;
		$cx2_2 = 10; $cx2_3 = 163;	
		$cx3_1=210; $cx3_2=275; $cx3_3=98; $cx3_4=-18; 		//$cx3_1, $cx3_2, $cx3_3, $cx3_4;
		$cx4_2 = 210; $cx4_3 = 90;	
		$cx5_1=210; $cx5_2=275; $cx5_3=118; $cx5_4=-18; 		//$cx1_1, $cx1_2, $cx1_3, $cx1_4;
		//$cx5_1=10; $cx5_2=160; $cx5_3=238; $cx5_4=-24;
		$cx6_2 = 210; $cx6_3 = 110;	
		$cx7_1=210; $cx7_2=275; $cx7_3=138; $cx7_4=-15; 		//$cx1_1, $cx1_2, $cx1_3, $cx1_4;
		$cx8_2 = 210; $cx8_3 = 130;	
	}
	
	if (strlen($logotipo)>4){
		if (file_exists("../../panel/".$datos->empresa_rfc."/logo/".$logotipo)) {
	    	$pdf->logo("../../panel/".$datos->empresa_rfc."/logo/".$logotipo, $logox1, $logoy1, $logosize-10 );  // Equivale a 40, le quito 5 y quedan 35
	    }
    }
    //	Vertical y Horizontal
	$pdf -> drawline($linea1X1, $linea1Y1, $linea1X2+6, $linea1Y2, $color_r, $color_g, $color_b); //x1, y1, x2, y1	
	$pdf -> drawline($linea1X1, $linea1Y1+0.2, $linea1X2+6, $linea1Y2+0.2 , $color_r, $color_g, $color_b); //x1, y1, x2, y1	

	//Dubujo la Segunda línea
	$pdf -> drawline($linea2X1, $linea2Y1-4, $linea2X2+6, $linea2Y2-4 , $color_r, $color_g, $color_b);	//x1, y1, x2, y1


	// Cabeceras*******************************************************
    $pdf->box_campos_salto( 
    	$datos->empresa_razonsocial. "\n".
        $datos->empresa_rfc."\n".
	    $datos->e_calle." ".$datos->e_noexterior." ".$datos->e_nointerior." ". $datos->e_cp." ".$datos->e_colonia." ".$datos->e_localidad." ".$datos->e_estado." ".$datos->e_pais."\n",
	    //$e_email." ".$e_tel
        45, 8    ,$color1,$color2,$color3, 'B', 9, 85, $tipoletra, 3 );

	
	$pdf->box_campos_salto(
		"CLIENTE: ".$datos->cliente_razonsocial."\n" ."".
		"RFC: ".$datos->cliente_rfc."\n".
		"DIRECCION:".$datos->c_calle." ".$datos->c_noexterior." ".$datos->c_nointerior." ". $datos->c_cp. " ".$datos->c_colonia." ". $datos->c_ciudad." ".$datos->c_estado.""
		."\nREGIMEN: ".utf8_decode($datos->cliente_regimenfiscal_clave. " ". $datos->cliente_regimenfiscal_nombre) ,
		10, 44, $color1, $color2, $color3, '', 7, 90, $tipoletra, 3); 

	$cfditipocambio = 1;
	$cfditipocambio = number_format($cfditipocambio,2);

    // Se agren los relacionados
    $relacionados = "";
    if ($datos->relacionados){
        foreach($datos->relacionados  as $i) { 
            $relacionados = $i->foliofiscal_sustituido. " ";
        }
    }
    
// Darle CTRL + Z Hasta QUITAR.
	//DATOS GENERALES 1
	$pdf->box_campos_salto(
	    "Tipo de Comprobante:   ".$datos->tipo." \n" . 
		"Uso de CFDI :       ".$datos->uso_clave." ".utf8_decode($datos->uso_nombre)."\n" . 
		"Tipo de Cambio : ".$cfditipocambio." \n".
		"Clave Confirm:   ".""." \n" . 
		"Relacionado :   ".$relacionados."\n" . 
		utf8_decode("Tipo Relación : "." "." \n"),
		45, 25, $color1, $color2, $color3, '', 8, 90, $tipoletra, 3); 


	//DATOS FISCALES
	$pdf->box_campos(
	    utf8_decode("Régimen Fiscal: ".$datos->empresa_regimenfiscal_clave." ".$datos->empresa_regimenfiscal_nombre." \n" . 
		"Lugar expedición: ".$datos->empresa_cp." \n" . 
		"Forma de pago : ".$datos->formapago_clave." ".$datos->formapago_nombre." \n" .
		"Método de pago :  ".$datos->metodopago_clave." ".$datos->metodopago_nombre." \n" .
		"Fecha Expedición: ".$datos->emision." \n") .
		"Moneda: ".$datos->moneda
		, 100,44, $color1, $color2, $color3, '', 8, 100, $tipoletra ); 

	
	$pdf-> box_campos_salto(
		"Observaciones\n".$datos->observaciones ,
		10, 69, $color1, $color2, $color3, '', 8, 120, $tipoletra, 3
	);
	 


	$fcalt = $fcalt -2; //Para Reporte
	//HORIZONTAL O VERTICAL, APLICA A AMBOS (LISTO)

	$pdf-> box_campos(
		"Factura No: ".$datos->folio. " ".$datos->serie,
		135, 10, $color1, $color2, $color3, 'B', 12, 80, $tipoletra
	);
	$pdf-> box_campos(
		utf8_decode(
		"Folio fiscal: ".$datos->foliofiscal.
		"\nNo Certificado CSD: ".$datos->csd.
		"\nSerie del emisor: ".$datos->csdpac.
		"\nFecha y hora de certificación: ".$datos->emision.
		"\nFecha y hora de emisión: ".$datos->emision),
		135, 17, $color1, $color2, $color3, '', 8, 80, $tipoletra
	);
	$pdf->box_rectangulo(135, 8, 71, 30, $color_r,$color_g,$color_b); // x, y, ando, alto

	
	$directorioraiz = "../../panel/".$datos->empresa_rfc."/cfdi/factura/cfdi/"; //Jasser 15 Octubre 2013
    $nombreQr = $directorioraiz."Factura_".$datos->empresa_rfc."_".$datos->folio."_".$datos->serie.".png";


    if (file_exists($nombreQr)) {
    	$pdf->Image($nombreQr,  $qrx-3, $qry-10, $qrprof ); // $qrx, $qry, $qrprof   //
    } 
    $status ="";
	if ($datos->status == "Prefactura" ) 	$status = "PREFACTURA";
	if ($datos->status == "Timbrado" ) 	$status = "";
	if ($datos->status == "Cancelado" ) $status = "CANCELADO";
	if ($datos->status == "Cancelada" ) $status = "CANCELADA";

	// KPIS Controla, se Integran los conceptos en esta parte
	$cols=array( 
		"CANTIDAD"     	=> 16,
        "UNIDAD\nM"  	=> 16,  
        "CVEPS" 		=> 16,
        //"NUMID" 		=> 12,
        "CVEUN" 		=> 11,
        "DESCRIPCION"  	=> 87,
        "OB IMP"		=> 10,
        "PRECIO"       	=> 20,
        "IMPORTE" 		=> 20 );  // SoBRA 11 <-- SoBRA 6 = 17 + 4 puntos - 21 <-- -10 = 11 puntos
	$xcfdi = "P";
	$alturamulticell = 85; //100;
	//if($xcfdi== 'P') $detalleconst += 50;
	// detalleconst es la altura del elemento
	$pdf->addCols( $cols, $detallex, $alturamulticell+2, $detalleconst, $tipoletra, 7, "", $detalleseparacion, $color1,$color2,$color3); // letra, x, y 	// $detallex=10; $detalley =97; $detalleconst=90
	$cols=array( 
		"CANTIDAD"    	=> "C",
        "UNIDAD\nM"  	=> "L",
        "CVEPS" 		=> "R",
        //"NUMID" 		=> "R",
        "CVEUN" 		=> "R",
        "DESCRIPCION"   => "L",
        "OB IMP"     => "L",
        "PRECIO"      	=> "R",
        "IMPORTE" 		=> "R" );

	$pdf->addLineFormat($cols); 
/*
	$pdf->marcono_text_left("","Num Cuenta: ".$banco." ".$numcta, $tituloxx-17, $tituloxy-5, $color1, $color2, $color3, '', 7, $tipoletra); //x, y, letrasize  // 165, 65, 5)
*/  
	//Coordenadas a Partir de Donde se empezarán a Imprimir los Detalles Jasser Portrait, Landscape, Horizontal, Vertical	
	$y = $alturamulticell+8; //Coordenadas a partir de donde se imprimir�n los detalles
	$bandera_add_hoja = false;

	foreach($datos->conceptos  as $i) { 

		$line = array( 
			"CANTIDAD"    	=> number_format($i->cantidad,2),
	        "UNIDAD\nM"  	=> " ".$i->unidad,
			"CVEPS" 		=> $i->claveprodserv,
			//"NUMID" 		=> " ", //$numeroidentificacion,
			"CVEUN" 		=> $i->claveunidad,
	        "DESCRIPCION"   => utf8_decode($i->descripcion),
	        "OB IMP" 		=> " ".$i->objetoimp,
	        "PRECIO"      	=> number_format($i->valorunitario,2),
	        "IMPORTE" 		=> number_format($i->importe,2) );

		$size = $pdf->addLinerows( $y+2, $line , $tipoletra, "",  7, 0,0,0,  0);
		$y   += $size + 2;
	 
		//Incresto la Paginación Jasser.
		if ($y >= 183  ){ // && $i<$sizeDetails-1){
			$pdf->AddPage();
			$y = 95;

			$pdf -> drawline($linea1X1, $linea1Y1, $linea1X2, $linea1Y2 ); //x1, y1, x2, y1	
			$pdf -> drawline($linea2X1, $linea2Y1, $linea2X2, $linea2Y2 );	//x1, y1, x2, y1

			$cfditipocambio = number_format($cfditipocambio,2);

		}
	}


	//Coordenadas a Partir de Donde se empezarán a Imprimir los Detalles Jasser Portrait, Landscape, Horizontal, Vertical	
	$y = $alturamulticell+8; //Coordenadas a partir de donde se imprimir�n los detalles

	$bandera_add_hoja = false;

		$pdf->temporaire( $status , 255, 0, 0,   $temporairex, $temporairey, $tipoletra );
		$pdf->firmaJasser("www.jasser.mx", $firmax, $firmay, 8, $tipoletra );  //  


		$datos->subtotal;
		$datos->cfdi_iva_traslado;
		$datos->cfdi_ieps_traslado;
		$datos->cfdi_iva_retenido;
		$datos->cfdi_isr_retenido;
		$datos->total;

		$x_coo = 168;
		$y_coo = 192;
		$separacion = 5;
		if ($datos->subtotal >0){
			// A) Coloca Título
			// B) Coloca Valor
			// C) Coloca Rectángulo
			$pdf-> box_campos("Subtotal ",	$x_coo, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra ); 
			$pdf-> box_campos("".number_format($datos->subtotal,2),	$x_coo-42, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra, "R" ); 
			$pdf->box_rectangulo($x_coo-2, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
			$pdf->box_rectangulo($x_coo+18, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
			//$pdf->box_rectangulo(135, 8, 71, 30, $color_r,$color_g,$color_b); // x, y, ando, alto

		}
		if ($datos->cfdi_iva_traslado>0){
			$y_coo+= $separacion;
			$pdf-> box_campos("IVA ",	$x_coo, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra ); 
			$pdf-> box_campos("".number_format($datos->cfdi_iva_traslado,2),$x_coo-42, $y_coo, $color1,$color2,$color3, '',8,80, $tipoletra , "R"); 
			$pdf->box_rectangulo($x_coo-2, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
			$pdf->box_rectangulo($x_coo+18, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto

		}
		if ($datos->cfdi_ieps_traslado>0){
			$y_coo+= $separacion;
			$pdf-> box_campos("IEPS ",	$x_coo, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra ); 
			$pdf-> box_campos("".number_format($datos->cfdi_ieps_traslado,2),$x_coo-42, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra, "R" ); 
			$pdf->box_rectangulo($x_coo-2, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
			$pdf->box_rectangulo($x_coo+18, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
		}
		if ($datos->cfdi_iva_retenido>0){
			$y_coo+= $separacion;
			$pdf-> box_campos("Ret IVA ",	$x_coo, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra ); 
			$pdf-> box_campos("".number_format($datos->cfdi_iva_retenido,2),	$x_coo-42, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra, "R" ); 
			$pdf->box_rectangulo($x_coo-2, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
			$pdf->box_rectangulo($x_coo+18, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
		}
		if ($datos->cfdi_isr_retenido>0){
			$y_coo+= $separacion;
			$pdf-> box_campos("RET ISR ",	$x_coo, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra ); 
			$pdf-> box_campos("".number_format($datos->cfdi_isr_retenido,2), $x_coo-42, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra, "R" ); 
			$pdf->box_rectangulo($x_coo-2, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
			$pdf->box_rectangulo($x_coo+18, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
		}
		if ($datos->total >0){
			$y_coo+= $separacion;
			$pdf-> box_campos("Total ",	$x_coo, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra ); 
			$pdf-> box_campos("".number_format($datos->total,	2), $x_coo-42, $y_coo, $color1, $color2, $color3, '', 8, 80, $tipoletra, "R" ); 
			$pdf->box_rectangulo($x_coo-2, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
			$pdf->box_rectangulo($x_coo+18, $y_coo-1, 20, 5, $color_r,$color_g,$color_b); // x, y, ando, alto
		}


		
		//JASSER INTACTO
		$pdf-> box_campos(
		$datos->montol ,
		10, 200, $color1, $color2, $color3, '', 8, 150, $tipoletra
		);
		$pdf->campos("","Importe de la factura con Letra      ", $cx2_2, $cx2_3   ,$color1,$color2,$color3, $tipoletra);
		
		$pdf->box_rectangulo(10-2, 200-2, 150+2, 10, $color_r,$color_g,$color_b); // x, y, ando, alto
			
		$pdf-> box_campos_salto(
			" ".$datos->sellodigital ,
			10, 224, $color1, $color2, $color3, '', 5, 150, $tipoletra, 2 ); // El último valor, separación entre saltos
		$pdf->box_rectangulo(10, 225, 150, 8,  $color_r,$color_g,$color_b); // x, y, ando, alto
		
		$pdf-> box_campos_salto(
			" ".$datos->sellosat , 
			10, 236, $color1, $color2, $color3, '', 5, 150, $tipoletra, 2 ); // El último valor, separación entre saltos
		$pdf->box_rectangulo(10, 237, 150, 8,  $color_r,$color_g,$color_b); // x, y, ando, alto

		$pdf-> box_campos_salto(
			" ".$datos->cadenaoriginal ,
			10, 248, $color1, $color2, $color3, '', 4.5, 150, $tipoletra, 2 );// El último valor, separación entre saltos
		$pdf->box_rectangulo(10, 249, 150, 8,  $color_r,$color_g,$color_b); // x, y, ando, alto

		$pdf->campos("","Sello digital del CFDI:      ", 10, 217      ,$color1,$color2,$color3, $tipoletra);
		$pdf->campos("","Sello del SAT:     ", 10, 229        ,$color1,$color2,$color3, $tipoletra);
		$pdf->campos("","Cadena Original del Complemento de Certificacion del SAT:     ",  10, 241  ,$color1,$color2,$color3, $tipoletra);
		

		$nombre = "Factura_".$datos->empresa_rfc."_" .$datos->folio. "_". $datos->serie.".pdf";
		$directorio_temp="../../panel/".$datos->empresa_rfc."/cfdi/factura/pdf/".$nombre;

        $pdf->Output("F", $directorio_temp, true);  
		$return_arr = array(
		    'resultado'   => "I",  
		    'documento'   => $directorio_temp  
		);
		echo json_encode($return_arr);

    }
    
   // }
    
    
?>