<?php
require('../tools/fpdf/fpdf.php');
define('EURO', chr(128) );
define('EURO_VAL', 6.55957 );

// Xavier Nicolay 2004
//Edici�n Jasser Veris�n 0.8 Factura Electr�nica
// Version 1.02

//////////////////////////////////////
// Public functions                 //
//////////////////////////////////////
//  function sizeOfText( $texte, $larg )
//  function addSociete( $nom, $adresse )
//  function addDate( $date )
//  function addPageNumber( $page )
//  function addReglement( $mode )
//  function addEcheance( $date )
//  function addNumTVA($tva)
//  function addReference($ref)
//  function addCols( $tab )
//  function addLineFormat( $tab )
//  function lineVert( $tab )
//  function addLine( $ligne, $tab )

//  function temporaire( $texte )
// 1,100 Líneas de Código
class PDF_Invoice extends FPDF {
// private variables
var $colonnes;
var $format;
var $angle=0;
// private functions
function RoundedRect($x, $y, $w, $h, $r, $style = '') {
	$k = $this->k;
	$hp = $this->h;
	if($style=='F')
		$op='f';
	elseif($style=='FD' || $style=='DF')
		$op='B';
	else
		$op='S';
	$MyArc = 4/3 * (sqrt(2) - 1);
	$this->_out(sprintf('%.2F %.2F m',($x+$r)*$k,($hp-$y)*$k ));
	$xc = $x+$w-$r ;
	$yc = $y+$r;
	$this->_out(sprintf('%.2F %.2F l', $xc*$k,($hp-$y)*$k ));

	$this->_Arc($xc + $r*$MyArc, $yc - $r, $xc + $r, $yc - $r*$MyArc, $xc + $r, $yc);
	$xc = $x+$w-$r ;
	$yc = $y+$h-$r;
	$this->_out(sprintf('%.2F %.2F l',($x+$w)*$k,($hp-$yc)*$k));
	$this->_Arc($xc + $r, $yc + $r*$MyArc, $xc + $r*$MyArc, $yc + $r, $xc, $yc + $r);
	$xc = $x+$r ;
	$yc = $y+$h-$r;
	$this->_out(sprintf('%.2F %.2F l',$xc*$k,($hp-($y+$h))*$k));
	$this->_Arc($xc - $r*$MyArc, $yc + $r, $xc - $r, $yc + $r*$MyArc, $xc - $r, $yc);
	$xc = $x+$r ;
	$yc = $y+$r;
	$this->_out(sprintf('%.2F %.2F l',($x)*$k,($hp-$yc)*$k ));
	$this->_Arc($xc - $r, $yc - $r*$MyArc, $xc - $r*$MyArc, $yc - $r, $xc, $yc - $r);
	$this->_out($op);
}

function _Arc($x1, $y1, $x2, $y2, $x3, $y3) {
	$h = $this->h;
	$this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c ', $x1*$this->k, ($h-$y1)*$this->k,
						$x2*$this->k, ($h-$y2)*$this->k, $x3*$this->k, ($h-$y3)*$this->k));
}

function Rotate($angle, $x=-1, $y=-1) {
	if($x==-1)
		$x=$this->x;
	if($y==-1)
		$y=$this->y;
	if($this->angle!=0)
		$this->_out('Q');
	$this->angle=$angle;
	if($angle!=0) {
		$angle*=M_PI/180;
		$c=cos($angle);
		$s=sin($angle);
		$cx=$x*$this->k;
		$cy=($this->h-$y)*$this->k;
		$this->_out(sprintf('q %.5F %.5F %.5F %.5F %.2F %.2F cm 1 0 0 1 %.2F %.2F cm',$c,$s,-$s,$c,$cx,$cy,-$cx,-$cy));
	}
}

function _endpage() {
	if($this->angle!=0)	{
		$this->angle=0;
		$this->_out('Q');
	}
	parent::_endpage();
}

// public functions
function sizeOfText( $texte, $largeur ) {
	$index    = 0;
	$nb_lines = 0;
	$loop     = TRUE;
	while ( $loop ) {
		$pos = strpos($texte, "\n");
		if (!$pos){
			$loop  = FALSE;
			$ligne = $texte;
		}
		else{
			$ligne  = substr( $texte, $index, $pos);
			$texte = substr( $texte, $pos+1 );
		}
		$length = floor( $this->GetStringWidth( $ligne ) );
		$res = 1 + floor( $length / $largeur) ;
		$nb_lines += $res;
	}
	return $nb_lines;
}

// Company RECEPTOR
function marcono_text_left( $nom, $adresse, $x1, $y1, $color1, $color2, $color3, $negrita, $sizeletra, $longtext, $tipoletra ) {
	//$x1 = 45;
	//$y1 = 5;
	//Positionnement en bas
	$negrita = "";
/*
	if ($tipoletra =='Comic') {
		$this->AddFont($tipoletra,'','COMIC.php'); 	
	} */
	//$this->AddFont('Comic','','comic.php'); 
	//$this->setFont('Comic', '', 9);


//	$this->SetXY( $x1, $y1 );	
//	$this->SetFont($tipoletra, $negrita, $sizeletra);	
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', $sizeletra);
	$length = $this->GetStringWidth( $nom );
	//$length = 100;

	$this->Cell( $length, 2, $nom, 0,0);
	$this->SetTextColor($color1, $color2, $color3); // 0,0,137 El color de Jasser
	$this->SetXY( $x1, $y1 + 4 );
	//$this->SetFont('Arial','',9);
	$length = $this->GetStringWidth( $adresse );
	//Coordonn�es de la soci�t�
	$lignes = $this->sizeOfText( $adresse, $length) ;
	
	//multi Cell Jasser
	//$this->MultiCell($length, 4, $adresse);
	$this->MultiCell($longtext, 4, $adresse);	
}

function marcono_text_left_sp3( $nom, $adresse, $x1, $y1, $color1, $color2, $color3, $negrita, $sizeletra, $longtext, $tipoletra ) {
	//$x1 = 45;
	//$y1 = 5;
	//Positionnement en bas
	/*
	if ($tipoletra =='Comic') {
		$this->AddFont($tipoletra,'','COMIC.php'); 	
	} else { }
	*/

	$this->SetXY( $x1, $y1 );	

	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', $sizeletra);

	$length = $this->GetStringWidth( $nom );
	//$length = 100;

	$this->Cell( $length, 2, $nom, 0,0);
	$this->SetTextColor($color1, $color2, $color3); // 0,0,137 El color de Jasser
	$this->SetXY( $x1, $y1 + 4 );
	//$this->SetFont('Arial','',9);
	$length = $this->GetStringWidth( $adresse );
	//Coordonn�es de la soci�t�
	$lignes = $this->sizeOfText( $adresse, $length) ;
	
	//multi Cell Jasser
	//$this->MultiCell($length, 4, $adresse);
	$this->MultiCell($longtext, 3, $adresse);	
}


function logo($nombrearchivo, $a1, $a2, $a3){
	$this->Image($nombrearchivo, $a1, $a2, $a3);
}



function subtotalMonto( $nom, $adresse , $x1, $y1) {
	//Positionnement en bas

	$this->SetXY( $x1, $y1 );
	$this->SetTextColor(0,34,0);
	//$this->SetFont('Arial','B',12);
	$length = $this->GetStringWidth( $nom );
	$this->Cell( $length, 2, $nom);
	$this->SetXY( $x1, $y1 + 4 );

	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', 8);

	$length = $this->GetStringWidth( $adresse );
	//Coordonn�es de la soci�t�
	$lignes = $this->sizeOfText( $adresse, $length) ;
	$this->MultiCell(25, 4, $adresse, 1,'R' );
}

function campos( $nom, $adresse, $x1, $y1    ,$color1,$color2,$color3){
	//Positionnement en bas
	$this->SetXY( $x1, $y1 );
	$this->SetTextColor($color1, $color2, $color3);
	//$this->SetFont('Arial','B',12);
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', 12);

	$length = $this->GetStringWidth( $nom );
	$this->Cell( $length, 2, $nom);
	$this->SetXY( $x1, $y1 + 4 );
	$this->SetFont('Arial','',8);

	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', 8);

	$length = $this->GetStringWidth( $adresse );
	//Coordonn�es de la soci�t�
	$lignes = $this->sizeOfText( $adresse, $length) ;
	$this->MultiCell($length, 4, $adresse);
}


function contacto( $nom, $adresse ){
    $this->SetDrawColor(0,0,100);
    
	$x1 = 10;
	$y1 = -25;
	//Positionnement en bas
	$this->SetXY( $x1, $y1 );
	$this->SetTextColor(0,0,0);
	//$this->SetFont('Arial','B',8);
	$length = $this->GetStringWidth( $nom );
	$this->Cell( $length, 2, $nom);
	$this->SetXY( $x1+100, $y1-1 );
	//$this->SetFont('Arial','',8);

	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', 8);

	$this->SetTextColor(254,0,0);
	$length = $this->GetStringWidth( $adresse );
	//Coordonn�es de la soci�t�
	$lignes = $this->sizeOfText( $adresse, $length) ;
	$this->MultiCell($length, 4, $adresse);
}


function Footer(){
$desarrolla ="Proveedores de Software de Facturacion electronica. Desarrollo de Software";
$text1 = " Este documento es una representacion impresa de un CFDI 3.3";

    // Posici�n: a 1,5 cm del final
    $this->SetY(-21);
    // Arial italic 8
	$this->SetTextColor(0,100,0);
    //$this->SetFont('Helvetica','B',6);
    $this->Cell(0,10,$desarrolla,0,0,'D');
	
	$this->SetTextColor(254,0,0);
	$this->SetY(-21);
	//$this->SetFont('Arial','',8);

	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', 8);

	$this->Cell(0,10,$text1,0,0, 'R'); // 'L' Left, Right
}

function informacion( $nom, $adresse ,  $x1, $y1) {
	//Positionnement en bas
	$this->SetXY( $x1, $y1 );
	$this->SetTextColor(0,0,0);
	//$this->SetFont('Arial','',10);
	$length = $this->GetStringWidth( $nom );
	$this->Cell( $length, 2, $nom);
	$this->SetXY( $x1, $y1 + 4 );
	//$this->SetFont('Arial','',8);
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', 8);
	$length = $this->GetStringWidth( $adresse );
	//Coordonn�es de la soci�t�
	$lignes = $this->sizeOfText( $adresse, $length) ;
	$this->MultiCell($length, 4, $adresse);
}



function drawline($x1, $y1, $x2, $y2){
	$this->SetDrawColor(150,150,150);
	$this->Line($x1, $y1, $x2, $y2);//impresi�n de linea
}


// Folio Fiscal CFDI
function marcosi_text_right( $libelle, $num, $ffstring, $ffolio, $ftextcsd, $csd, $csdpac, $emision/*, $fdateemision*/, $adicional, $constantealtura_cuadro, $c2, $v1, $altura, $szfont ){
	//$constantealtura_cuadro= 29;
    $r1  = $this->w - $c2; //aqui
    $r2  = $r1 + $v1;//aqui
    $y1  = $altura	; // aqui
    $y2  = $y1 + 2;
    $mid = ($r1 + $r2 ) / 2;
	$constante=22;
    
    //$texte  = $libelle . " EN " . EURO . " N° : " . $num;    
	$texte = $libelle .$num;
    //$szfont = 9;
    $loop   = 0;
    
	//$this->SetFont( "Arial", "", $szfont );
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', $szfont);

    while ( $loop == 0 ){
       //$this->SetFont( "Arial", "", $szfont );
       $sz = $this->GetStringWidth( $texte );
       if ( ($r1+$sz) > $r2 )
          $szfont --;
       else
          $loop ++;
    }

    $this->SetLineWidth(0.5); //ok
    //$this->SetFillColor(185,202,245); //ok
	$this->SetFillColor(255,255,255);
    $this->RoundedRect($r1, $y1, ($r2 - $r1), $constantealtura_cuadro+$y2, 0, 'DF');//ok
	
	//$this->SetFont( "Arial", "B", 10);//$szfont ); //Aquí se cambia el tamaño del Número de la Factura
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', $szfont);

    $this->SetXY( $r1+1, $y1+2);	//ok
    $this->Cell($r2-$r1 -1,5, $texte, 0, 0, "R" ); //OK
	
	$this->SetFont( "Arial", "", 8);//$szfont );	
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+4, $ffstring, 0, 0, "R" ); //OK
	
	$this->setFont("Arial","B",8);
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+12, $ffolio, 0, 0, "R" ); //OK

	$this->SetFont( "Arial", "", 8);//$szfont );
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+21, $ftextcsd, 0, 0, "R" ); //OK

	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+30, $csd, 0, 0, "R" ); //OK

	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+39, $csdpac, 0, 0, "R" ); //OK
	
	$this->SetFont( "Arial", "", 8);
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+48, $emision, 0, 0, "R" ); //OK
	

	//$this->SetXY( $r1+1, $y1+2);	//ok
	//$this->Cell($r2-$r1 -1, $y2+57, $fdateemision, 0, 0, "R" ); //OK	
		
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+57, $adicional, 0, 0, "R" ); //OK	

//$ftextcsd, $csd, $emision, $fdateemision	
}


// Folio Fiscal CFDI
function marcosi_text_right_( $texto,  $constantealtura_cuadro, $c2, $v1, $altura, $szfont ){
	//$constantealtura_cuadro= 29;
    $r1  = $this->w - $c2; //aqui
    $r2  = $r1 + $v1;//aqui
    $y1  = $altura	; // aqui
    $y2  = $y1 + 2;
    $mid = ($r1 + $r2 ) / 2;
	$constante=22;
    
    $loop   = 0;
    
	$this->SetFont( "Arial", "", $szfont );
    while ( $loop == 0 ){
       //$this->SetFont( "Arial", "", $szfont );
       $sz = $this->GetStringWidth( $texte );
       if ( ($r1+$sz) > $r2 )
          $szfont --;
       else
          $loop ++;
    }

    $this->SetLineWidth(0.5); //ok
    //$this->SetFillColor(185,202,245); //ok
	$this->SetFillColor(255,255,255);
    $this->RoundedRect($r1, $y1, ($r2 - $r1), $constantealtura_cuadro+$y2, 0, 'DF');//ok
	
	//$this->SetFont( "Arial", "B", 10);//$szfont ); //Aquí se cambia el tamaño del Número de la Factura

	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', 10);

    $this->SetXY( $r1+1, $y1+2);	//ok
    $this->Cell($r2-$r1 -1,5, $texto, 0, 0, "R" ); //OK
}

// Folio Fiscal CFDI
function marcosi_text_left_c( $libelle, $num, $ffstring, $ffolio, $ftextcsd, $csd, $csdpac, $emision/*, $fdateemision*/, $adicional, $constantealtura_cuadro, $c2, $v1, $altura, $szfont ){
	//$constantealtura_cuadro= 29;
    $r1  = $this->w - $c2; //aqui
    $r2  = $r1 + $v1;//aqui
    $y1  = $altura	; // aqui
    $y2  = $y1 + 2;
    $mid = ($r1 + $r2 ) / 2;
	$constante=22;
    
    //$texte  = $libelle . " EN " . EURO . " N° : " . $num;    
	$texte = $libelle .$num;
    //$szfont = 9;
    $loop   = 0;
    
	//$this->SetFont( "Arial", "", $szfont );
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', $szfont);

    while ( $loop == 0 ){
       //$this->SetFont( "Arial", "", $szfont );
       $sz = $this->GetStringWidth( $texte );
       if ( ($r1+$sz) > $r2 )
          $szfont --;
       else
          $loop ++;
    }

    $this->SetLineWidth(0.5); //ok
    //$this->SetFillColor(185,202,245); //ok
	$this->SetFillColor(255,255,255);
    $this->RoundedRect($r1, $y1, ($r2 - $r1), $constantealtura_cuadro+$y2, 0, 'DF');//ok
	
	//$this->SetFont( "Arial", "B", 10);//$szfont ); //Aquí se cambia el tamaño del Número de la Factura
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', $szfont+2);

    $this->SetXY( $r1+1, $y1+2);	//ok
    $this->Cell($r2-$r1 -1,5, $texte, 0, 0, "L" ); //OK
	
	//$this->SetFont( "Arial", "", 8);//$szfont );	
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', 8);
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+4, $ffstring, 0, 0, "L" ); //OK
	
	//$this->setFont("Arial","B",8);
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+12, $ffolio, 0, 0, "L" ); //OK

	//$this->SetFont( "Arial", "", 8);//$szfont );
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+21, $ftextcsd, 0, 0, "L" ); //OK

	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+30, $csd, 0, 0, "L" ); //OK

	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+39, $csdpac, 0, 0, "L" ); //OK
	
	//$this->SetFont( "Arial", "", 8);
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+48, $emision, 0, 0, "L" ); //OK
	

	//$this->SetXY( $r1+1, $y1+2);	//ok
	//$this->Cell($r2-$r1 -1, $y2+57, $fdateemision, 0, 0, "R" ); //OK	
		
	$this->SetXY( $r1+1, $y1+2);	//ok
	$this->Cell($r2-$r1 -1, $y2+57, $adicional, 0, 0, "L" ); //OK	

//$ftextcsd, $csd, $emision, $fdateemision	
}


//Rectángulo de Datos.
function marcosi_rectangulo ($libelle, $r1, $r2, $y1, $y2, $szfont ){ //10, 135, 200, -24, 8 
    $this->SetFillColor(220,220,220);  
    $this->RoundedRect($r1, $y1, ($r2 - $r1), 32+$y2, 0, 'DF');//ok
	$this->SetAlpha(0.8);	
}



function marcosi_text_center( $libelle, $r1, $r2, $y1, $y2, $szfont   ){ //10, 135, 200, -24, 8 

    $mid = ($r1 + $r2 ) / 2;    
    //$texte  = $libelle . " EN " . EURO . " N� : " . $num;    
	$texte = $libelle ;//.$num;
    //$szfont = 8;
    $loop   = 0;
    
    $this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', $szfont);
    while ( $loop == 0 ) {
       //$this->SetFont( "Arial", "B", $szfont ); // "", Fuelco, agregué la "B"
       $sz = $this->GetStringWidth( $texte );
       if ( ($r1+$sz) > $r2 )
          $szfont --;
       else
          $loop ++;
    }

    $this->SetLineWidth(0.5); //ok
    $this->SetFillColor(255,2550,255); //ok
    $this->RoundedRect($r1, $y1, ($r2 - $r1), 32+$y2, 0, 'DF');//ok
    $this->SetXY( $r1+1, $y1+1);	//ok
    $this->Cell($r2-$r1 -1,2, $texte, 0, 0, "C" ); //OK
}


function marcosi_text_left( $libelle, $r1, $r2, $y1, $y2, $szfont ){ 
    $mid = ($r1 + $r2 ) / 2;
    $num = "1001";
    //$texte  = $libelle . " EN " . EURO . " N� : " . $num;    
	$texte = $libelle .$num;
    //$szfont = 8;
    $loop   = 0;
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', $szfont);    
    //$this->SetFont( "Arial", "",$szfont);

    $this->SetLineWidth(0.5); //ok
    $this->SetFillColor(255,2550,255); //ok
    $this->RoundedRect($r1, $y1, ($r2 - $r1), 32+$y2, 0, 'DF');//ok
    $this->SetXY( $r1+1, $y1+1);	//+1 lo sube hacia arriba obvio
    
	$this->MultiCell($r2-$r1 -1, 2, $libelle);
}

function marcosi_text_left_sp3( $libelle, $r1, $r2, $y1, $y2, $szfont ){ 
    $mid = ($r1 + $r2 ) / 2;
    $num = "1001";
    //$texte  = $libelle . " EN " . EURO . " N� : " . $num;    
	$texte = $libelle .$num;
    //$szfont = 8;
    $loop   = 0;
    $this->SetFont( "Arial", "",$szfont);

    $this->SetLineWidth(0.5); //ok
    $this->SetFillColor(255,2550,255); //ok
    $this->RoundedRect($r1, $y1, ($r2 - $r1), 32+$y2, 0, 'DF');//ok
    $this->SetXY( $r1+1, $y1+1);	//+1 lo sube hacia arriba obvio
    
	$this->MultiCell($r2-$r1 -1, 3, $libelle);
}


function marcosi_text_right_sp3( $texte, $r1, $r2, $y1, $y2, $szfont ){ 
    $loop   = 0;
    $this->SetFont( "Arial", "",$szfont);
    $this->SetLineWidth(0.2); //ok

    $this->SetFillColor(220,220,220);  
    
    $this->RoundedRect($r1, $y1, ($r2 - $r1), 32+$y2, 0, 'DF');//ok
    $this->SetXY( $r1+0, $y1+2);	//+1 lo sube hacia arriba obvio
    
	$this->MultiCell($r2-$r1 -1, 2, $texte);
} //535



function cadenax( $libelle,  $r1, $r2, $y1, $y2, $letrasize) {  // 10, 195, 78, -13, 8 //letra último 
    $mid = ($r1 + $r2 ) / 2;
    $szfont = 5;

	$this->SetFont( "Arial", "", $letrasize);	
    $this->SetLineWidth(0.1); //ok
    $this->SetFillColor(255,2550,255); //ok
	
	$this->SetXY( $r1+1, $y1+1);	//ok
	$this->MultiCell($r2-$r1 -1, 3, $libelle);
	return $this->GetY();
}


function addDate( $date ) {
	$r1  = $this->w - 61;
	$r2  = $r1 + 30;
	$y1  = 17; //Coordenadas de Inicio Jas
	$y2  = $y1 ;
	$mid = $y1 + ($y2 / 2);
	$this->RoundedRect($r1, $y1, ($r2 - $r1), $y2, 3.5, 'D');
	$this->Line( $r1, $mid, $r2, $mid);
	$this->SetXY( $r1 + ($r2-$r1)/2 - 5, $y1+3 );
	$this->SetFont( "Arial", "B", 10);
	$this->Cell(10,5, "DATE", 0, 0, "C");
	$this->SetXY( $r1 + ($r2-$r1)/2 - 5, $y1+9 );
	$this->SetFont( "Arial", "", 10);
	$this->Cell(10,5,$date, 0,0, "C");
}



function addPageNumber( $page ) {
	$r1  = $this->w - 80;
	$r2  = $r1 + 19;
	$y1  = 17; //Coordenadas de Inicio Jas
	$y2  = $y1;
	$mid = $y1 + ($y2 / 2);
	$this->RoundedRect($r1, $y1, ($r2 - $r1), $y2, 3.5, 'D');
	$this->Line( $r1, $mid, $r2, $mid);
	$this->SetXY( $r1 + ($r2-$r1)/2 - 5, $y1+3 );
	$this->SetFont( "Arial", "B", 10);
	$this->Cell(10,5, "PAGE", 0, 0, "C");
	$this->SetXY( $r1 + ($r2-$r1)/2 - 5, $y1 + 9 );
	$this->SetFont( "Arial", "", 10);
	$this->Cell(10,5,$page, 0,0, "C");
}



function addCols( $tab, $r1, $y1, $constan_,  $letra, $stylelet, $limite0,  $color1, $color2,$color3 ){ // 10, 97
	global $colonnes;

	$this->SetFillColor(0,100,240);
	//$r1  = 10;
	$r2  = $this->w - ($r1 * 2) ;
	//$r2= $r2-100;

	//$y1  = 97;
	$y2  = $this->h -  $constan_  - $y1;
	$this->SetXY( $r1, $y1 );
	$this->SetFillColor(10,100,240);
	$this->SetTextColor($color1, $color2, $color3);
	
	$r2= $r2-$limite0;
	$this->Rect( $r1, $y1, $r2, $y2, "D");	 
	$this->Line( $r1, $y1+6, $r1+$r2, $y1+6); 
	$colX = $r1;
	$colonnes = $tab;
	//$this->SetFont( "Arial", $stylelet, $letra);
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', ''); //Size

	while ( list( $lib, $pos ) = each ($tab) )	{
	    $this->SetFillColor(0,0,240);
		$this->SetXY( $colX, $y1+2 );  			 
		$this->Cell( $pos, 1, $lib, 0, 0, "DF");  
		$colX += $pos;
		$this->Line( $colX, $y1, $colX, $y1+$y2); 
	}
	$this->SetFillColor(0,100,240);
}



function addLineFormat( $tab ){ //Color de Texto
	global $format, $colonnes;
	$this->SetFillColor(0,0,255);
	while ( list( $lib, $pos ) = each ($colonnes) )	{ //echo "<br>".$lib;
		if ( isset( $tab["$lib"] ) )
			$format[ $lib ] = $tab["$lib"];
			$this->SetFillColor(0,100,240); 
	}
}

function lineVert( $tab ){
	global $colonnes;
    $this->SetFillColor(10,100,240);
	reset( $colonnes ); 

	$maxSize=0;
	while ( list( $lib, $pos ) = each ($colonnes) )	{
		$texte = $tab[ $lib ];
		$longCell  = $pos -2;
		$size = $this->sizeOfText( $texte, $longCell );
		if ($size > $maxSize)
			$maxSize = $size;
	}
	return $maxSize;
}


function addLine( $ligne, $tab, $textstyle, $textsize,  $delimitacion ) { //7, B
	global $colonnes, $format;

	$colonnes = $colonnes;

	$this->SetTextColor(0,	0, 0); //si no pongo color agarra el azul
	$ordonnee     = 10; // Es la coordenada de Inicio de la Información
	$maxSize      = $ligne;

	reset( $colonnes );
	while ( list( $lib, $pos ) = each ($colonnes) )	{
//echo "Jasser ";
		$longCell  = $pos -1; //Era -2 <-- La pared de la Hoja

		$this->AddFont('Comic','','comic.php'); 
		$this->setFont('Comic', '', $textsize);

		//$this->SetFont( "Arial",  $textstyle, $textsize);


		//$this->SetFillColor(200,200,240);
		$texte     = $tab[ $lib ];
		//echo $texte; //Imprime el Texto
		$length    = $this->GetStringWidth( $texte ); 
		//echo " *".number_format($length, 2);
		$tailleTexte = $this->sizeOfText( $texte, $length );
		//echo " (".$tailleTexte.")"; //Según ancho de Texto
		$formText  = $format[ $lib ];
		//echo " $formText"; //Imprime Izq o Derecha
		$this->SetXY( $ordonnee, $ligne-1);
		//echo " ".$ordonnee; //Imprimer las coordenadas
		$this->MultiCell( $longCell, 3 , $texte, 0, $formText); //4 la separación entre líneas
		//echo " *".$longCell; //Ancho de Líneas
		if ( $maxSize < ($this->GetY()  ) )
			$maxSize = $this->GetY() ;
		//echo " Jasser".$this->GetY(); //Imprime la Coordenada
		$ordonnee += $pos;
	}
	return ( $maxSize - $ligne );
}

//Sombreado impar* * * * * * * * * * * * * * * * * * * * * * * * 
function addLinerows( $ligne, $tab, $textstyle, $textsize,  $delimitacion ) { //7, B
	global $colonnes, $format;
	$rows_impar = 0; //Impar color

	$colonnes = $colonnes;

	$this->SetTextColor(0,	0, 0); //si no pongo color agarra el azul
	$ordonnee     = 10; // Es la coordenada de Inicio de la Información
	$maxSize      = $ligne;

	reset( $colonnes ); // $texte = Datos
	while ( list( $lib, $pos ) = each ($colonnes) )	{

		$longCell  = $pos -1; //Era -2 <-- La pared de la Hoja
		$this->SetFont( "Arial",  $textstyle, $textsize);

		$texte     = $tab[ $lib ];
		$length    = $this->GetStringWidth( $texte );
		$tailleTexte = $this->sizeOfText( $texte, $length );
		$formText  = $format[ $lib ];
		$this->SetXY( $ordonnee, $ligne-1);


		$this->MultiCell( $longCell, 4 , $texte, 0, $formText);
		if ( $maxSize < ($this->GetY()  ) )
			$maxSize = $this->GetY() ;
		$ordonnee += $pos;
	}
	return ( $maxSize - $ligne );
}


//Aqu� va el Texto inclinado
function temporaire( $texte, $c1, $c2, $c3 , $rot1, $rot2){
	//$this->SetFont('Arial','B',50);
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', 50);

	$this->SetTextColor($c1, $c2, $c3);
	$this->Rotate(45, $rot1, $rot2); //Rotación a 45 °
	$this->Text(70,190,$texte);
	$this->Rotate(0);	//Rotación a 0°
	$this->SetTextColor(0,0,0);
}


//Aquí va la segunda Firma de Jasser
function firmaJasser( $texte, $x_, $y_ , $sizeword){
	//$this->SetFont('Arial','B', $sizeword);
	$this->AddFont('Comic','','comic.php'); 
	$this->setFont('Comic', '', $sizeword);

	$this->SetTextColor(0,100,0); //Color
	$this->Rotate(90,$x_, $y_);
	$this->Text($x_, $y_,$texte);
	$this->Rotate(0);
	$this->SetTextColor(0, 0, 0);
}


// 13 de Agosto 2016**********************************************************
	//COPIA ES PARA AGREGAR MAS PIES DE PAGINA .COPIA
function titulomaspiesdepagina( $nom, $adresse,$x1,$y1 ) {
	//$x1 = 37;
	//$y1 = 2;
	//Positionnement en bas
	$this->SetXY( $x1, $y1 );
	$this->SetTextColor(0,0,0);
	$this->SetFont('Arial','B',20);
	$length = $this->GetStringWidth( $nom );
	$this->Cell( $length, 6, $nom);
	$this->SetXY( $x1, $y1 + 7 );
	$this->SetFont('Arial','',10);
	$length = $this->GetStringWidth( $adresse );
	//Coordonnées de la société
	$lignes = $this->sizeOfText( $adresse, $length) ;
	$this->MultiCell($length, 4, $adresse);
	
}

//este esta ligado con ex., ya tiene las cordenadas el otro formato
function tituloempresa( $nom, $adresse,$x1,$y1, $sizeletra ) {
	$this->SetXY( $x1, $y1 );
	$this->SetTextColor(0,0,0);
	$this->SetFont('Arial','B',20);
	$length = $this->GetStringWidth( $nom );
	$this->Cell( $length, 6, $nom);
	$this->SetXY( $x1, $y1 + 7 );
	$this->SetFont('Arial','',$sizeletra);
	$length = $this->GetStringWidth( $adresse );
	//Coordonnées de la société
	$lignes = $this->sizeOfText( $adresse, $length) ;
	$this->MultiCell($length, 4, $adresse);
}

//este esta ligado con ex., ya tiene las cordenadas el otro formato
function textoCombinado( $nom, $adresse, $bold, $Normal, $x1,$y1, $sizeletra ) {
	$this->SetXY( $x1, $y1 );
	$this->SetTextColor(0,0,0);
	$this->SetFont('Arial','B',20);
	$length = $this->GetStringWidth( $nom );
	$this->Cell( $length, 6, $nom);
	$this->SetXY( $x1, $y1 + 7 );
	$this->SetFont('Arial','',$sizeletra);
	$length = $this->GetStringWidth( $adresse );
	//Coordonnées de la société
	$lignes = $this->sizeOfText( $adresse, $length) ;
	$this->MultiCell($length, 4, $adresse);
}


function textosinMarcoConTiulo( $nom, $subtitulo,  $x1, $y1, $sizeletra, $sizeletraTitle ) {
	//$x1 = 10;
	//$y1 = 40;
	//Positionnement en bas
	$this->SetXY( $x1, $y1 );
	$this->SetXY( $x1, $y1 );
	$this->SetTextColor(0,0,0);
	$this->SetFont('Arial','B', $sizeletraTitle);
	$length = $this->GetStringWidth( $nom );
	$this->Cell( 40, 2, $nom); //$LENGTH
	$this->SetXY( $x1, $y1 + 4 );
	$this->SetFont('Arial','', $sizeletra);
	$length = $this->GetStringWidth( 7 );
	//Coordonn�es de la soci�t�
	$lignes = $this->sizeOfText( $subtitulo, 40) ; //$length
	$this->MultiCell(90, 4, $subtitulo); //$length
}

//Revisar Función detenidamente
function textosinMarco( $subtitulo,  $x1, $y1, $sizeletra ) {
	$this->SetXY( $x1, $y1 );
	$this->SetXY( $x1, $y1 );
	$this->SetTextColor(0,0,0);
	//$this->SetFont('Arial','B', $sizeletra);
	//$length = $this->GetStringWidth( $nom );
	//$this->Cell( 40, 2, $nom); //$LENGTH
	//$this->SetXY( $x1, $y1 + 4 );
	$this->SetFont('Arial','', $sizeletra);
	$length = $this->GetStringWidth( $subtitulo );
	//$this->Cell( 40, 2, $nom); //$LENGTH
	//Coordonn�es de la soci�t�
	$lignes = $this->sizeOfText( $subtitulo, 80) ; //$length
	$this->MultiCell(90, 4, $subtitulo); //$length
}


function textoConMarco( $libelle, $r1, $r2, $y1, $y2, $szfont ){  //10, 160, 225, -24, 8
    /*
    $r1  = 10;
    $r2  = 160;
    $y1  = 225; //229
	$y2  = -24;
	*/

    $mid = ($r1 + $r2 ) / 2;
    $num = "1001";
    //$texte  = $libelle . " EN " . EURO . " N� : " . $num;    
	$texte = $libelle .$num;
    $loop   = 0;
    $this->SetFont( "Arial", "",$szfont);

    $this->SetLineWidth(0); //ok
    $this->SetFillColor(255,2550,0); //ok
    $this->RoundedRect($r1, $y1, ($r2 - $r1), 32+$y2, 1, 'DF');// el 1 Es la Curvatura
    $this->SetXY( $r1+1, $y1+2);	//ok
    
	$this->MultiCell($r2-$r1 -1, 3, $libelle);
}

function textoConMarcoDerecha( $nom, $adresse , $x1, $y1, $sizeletra) {
	//$x1 = 182;	$y1 = 190;
	//Positionnement en bas
	$this->SetXY( $x1, $y1 );
	$this->SetTextColor(0,34,100);
	$this->SetFont('Arial','B',12);
	$length = $this->GetStringWidth( $nom );
	$this->Cell( $length, 2, $nom);
	$this->SetXY( $x1, $y1 + 4 );
	$this->SetFont('Arial','', $sizeletra);
	$length = $this->GetStringWidth( $adresse );
	//Coordonn�es de la soci�t�
	$lignes = $this->sizeOfText( $adresse, $length) ;
	$this->MultiCell(25, 4, $adresse, 1,'R' );
}




// Esta parte es para la transparencia 
//La siguiente parte la enlazo a Transparencia
var $extgstates = array();

	// alpha: real value from 0 (transparent) to 1 (opaque)
	// bm:    blend mode, one of the following:
	//          Normal, Multiply, Screen, Overlay, Darken, Lighten, ColorDodge, ColorBurn,
	//          HardLight, SoftLight, Difference, Exclusion, Hue, Saturation, Color, Luminosity
	function SetAlpha($alpha, $bm='Normal')	{
		// set alpha for stroking (CA) and non-stroking (ca) operations
		$gs = $this->AddExtGState(array('ca'=>$alpha, 'CA'=>$alpha, 'BM'=>'/'.$bm));
		$this->SetExtGState($gs);
	}

	function AddExtGState($parms)	{
		$n = count($this->extgstates)+1;
		$this->extgstates[$n]['parms'] = $parms;
		return $n;
	}

	function SetExtGState($gs)	{
		$this->_out(sprintf('/GS%d gs', $gs));
	}

	function _enddoc()	{
		if(!empty($this->extgstates) && $this->PDFVersion<'1.4')
			$this->PDFVersion='1.4';
		parent::_enddoc();
	}

	function _putextgstates(){
		for ($i = 1; $i <= count($this->extgstates); $i++)	{
			$this->_newobj();
			$this->extgstates[$i]['n'] = $this->n;
			$this->_out('<</Type /ExtGState');
			$parms = $this->extgstates[$i]['parms'];
			$this->_out(sprintf('/ca %.3F', $parms['ca']));
			$this->_out(sprintf('/CA %.3F', $parms['CA']));
			$this->_out('/BM '.$parms['BM']);
			$this->_out('>>');
			$this->_out('endobj');
		}
	}

	function _putresourcedict(){
		parent::_putresourcedict();
		$this->_out('/ExtGState <<');
		foreach($this->extgstates as $k=>$extgstate)
			$this->_out('/GS'.$k.' '.$extgstate['n'].' 0 R');
		$this->_out('>>');
	}

	function _putresources()	{
		$this->_putextgstates();
		parent::_putresources();
	}



//}
// 832 Líneas de Código

}
?>
