<?php
get_registros();

function get_registros(  ) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT  
    A.foliofiscal, A.empresa_id, A.cliente_id, A.sellodigital, A.total, 
    A.folio, A.serie, 
    E.rfc AS empresa_rfc,  
    C.rfc AS cliente_rfc 
    FROM factura  A 
    LEFT JOIN empresa E ON (A.empresa_id = E.id ) 
    LEFT JOIN cliente C ON (A.cliente_id = C.id ) 
    WHERE 1 "; 

    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    

    $return_arr = array();
    if (!empty($datos)) {
        foreach($datos as $k=>$v) {  
            /*$return_arr[] = array(
            'id'            => $datos[$k]["id"], 
            'nombre'   => $datos[$k]["nombre"] 
            );
            */

	        $uuid 		= $datos[$k]["foliofiscal"];
	        $empresa_rfc= $datos[$k]["empresa_rfc"];
	        $cliente_rfc= $datos[$k]["cliente_rfc"];
	        $total      = $datos[$k]["total"];
	        $folio      = $datos[$k]["folio"];
	        $serie      = $datos[$k]["serie"];
	        $sellocfd   = $datos[$k]["sellodigital"];

	        echo "<br>=> ".$folio. "-".$serie. " = ".$empresa_rfc;
	        $ultimos8 = "";
	        if (strlen($sellocfd)>10)
	        	$ultimos8 = substr($sellocfd, -8);

	        $contenido_qr = "https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=".$uuid."&re=".$empresa_rfc."&rr=".$cliente_rfc."&tt=".$total."&fe=".$ultimos8;

	        // Crear el QR
	        $file = "../../panel/FME980828V79/cfdi/factura/cfdi/"."Factura_FME980828V79_".$folio."_".$serie.".png";
			//include("crea_qr.php");
	        recibe_datos($file,  $contenido_qr, "code" );

        }
    }
    //echo json_encode($return_arr);
}


    function recibe_datos($directorio, $datos, $prefijo){ 
        //$archivo = $PNG_TEMP_DIR."code_".$id.'.png';

        //$archivo = $prefijo."_".$id.'.png';

        $matrixPointSize = 5; // $matrixPointSize = 5; 
        $errorCorrectionLevel = 'M'; // array('L','M','Q','H' 

        $PNG_TEMP_DIR = dirname(__FILE__).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;
        //echo "Directorio: ".$PNG_TEMP_DIR;
        $PNG_WEB_DIR = '../dossier/';
        //$directorio =  '../dossier/';;
        create_qr($directorio, $datos, $matrixPointSize, $errorCorrectionLevel);
    }


    // Función crear Quick Response
    function create_qr($directorio, $datos, $matrixPointSize, $errorCorrectionLevel){ 
        //Incluye la librería
        include_once "../tools/phpqrcode/qrlib.php"; 
        //ofcourse we need rights to create temp dir
        /*
        if (!file_exists($PNG_TEMP_DIR))
            mkdir($PNG_TEMP_DIR);
            */
        //echo "Dire: ".$directorio; 
        //if (!file_exists($directorio))
        //    mkdir($directorio);

        QRcode::png($datos, $directorio, $errorCorrectionLevel, $matrixPointSize, 2); 
      
        //display generated file
        //echo '<img src="'.$directorio.basename($archivo).'" />';  // <hr/>
    }


?>