<?php
    require('../utilerias/clasePdf_2022.php');

    $pdf = new PDF_Invoice( 'L', 'mm', 'LETTER' );
    $pdf->AddPage();

    // Recupero el JSON enviado
    $datos = $_POST["datos"];
    $datos = json_decode($datos);   

    $rfc_dossier = $datos->rfc;  
    $logotipox = ""; 
    if ($datos->logo_cabecera != "")
        $logotipox = "../../panel/".$rfc_dossier."/logo/".$datos->logo_cabecera;

    $color1 = $color2 = $color3 = "00";
    $tipoletra = "Arial";

    // Integración de cabeceras
    $e_nombre= $datos->razon_social;  
    $e_rfc   = $rfc_dossier;
    $e_direc = $datos->direccion;
 
    // Datos de la empresa
    $pdf->box_campos( 
        $e_nombre. " ".$e_rfc. " \n". $e_direc, 
        47, 10    ,$color1,$color2,$color3, '', 9, 110, $tipoletra);

    $pdf->box_campos( 
        utf8_decode($datos->titulo) , 
        47, 25, $color1, $color2, $color3, '', 9, 110, $tipoletra);

    if (file_exists($logotipox)) {
        $pdf->logo($logotipox, 10, 5, 25);//, 8, 8, 33);
    }
    
     $cols=array( 
        //"Empresa_id" =>30 ,
        "Num" => 10,
        "Cliente" =>84 ,
        "Folio" =>12 ,
        "Serie" =>17 ,
        "Fecha" =>19 ,
        "Forma pago" =>30 ,
        "Moneda" =>13 ,
        "Folio fiscal" =>58 ,
        "Status" =>18    );
    $pdf->addCols($cols, 10, 35, 30, $tipoletra,  8, 'B', 0, 0, 0, 0);

     $cols=array( 
        "Num" => "R",
        "Cliente" =>"L" ,
        "Folio" =>"R" ,
        "Serie" =>"L" ,
        "Fecha" =>"L" ,
        "Forma pago" =>"L" ,
        "Moneda" =>"L" ,
        "Folio fiscal" =>"L" ,
        "Status" =>"L"
    );
    $pdf->addLineFormat($cols);

    $y    = 45;
    $contador = 0;
    $acumula = 0;
    foreach($datos->lista as $i) {
        $contador += 1;
        $acumula += 1;
      
        $cliente_id =stripslashes($i->cliente_id);   
        $folio =stripslashes($i->folio);   
        $serie =stripslashes($i->serie);   
        $fecha =stripslashes($i->fecha);   
        $formapago =stripslashes($i->formapago);   
        $moneda =stripslashes($i->moneda);   
        $foliofiscal =stripslashes($i->foliofiscal);   
        $tipo =stripslashes($i->tipo);   
        $status =stripslashes($i->status); 
    
        $line = array( 
            "Num" => $acumula,
            "Cliente"  => " ".substr(utf8_decode($cliente_id), 0, 70), 
            "Folio"  => " ".utf8_decode($folio), 
            "Serie"  => " ".utf8_decode($serie), 
            "Fecha"  => " ".substr(utf8_decode($fecha), 0, 10), 
            "Forma pago"  => " ".utf8_decode($formapago), 
            "Moneda"  => " ".utf8_decode($moneda), 
            "Folio fiscal"  => " ".utf8_decode($foliofiscal), 
            "Status"  => " ".utf8_decode($status)
        );
        $y1 = $y;

/*
        if ($contador%2==0)
            $pdf->rectangulo (10, 269.5, $y1-1, -28); 
*/
        $color1 = 0; $color2 =0; $color3 =0;
        if ($status== "Cancelado") $color1 = 255;
        if ($status== "Prefactura") { 
            /*
            $color1 = 27; 
            $color2 = 164;
            $color3 = 227;
            */
            $color1 = 232; 
            $color2 = 102;
            $color3 = 109;
        }

        // Imprime los registros
        $size = $pdf->addLinerows( $y, $line , $tipoletra, "", 6, $color1, $color2, $color3,  0); // Se pueden agregar Colores (0, 0, 0)
        $y   += $size + 2;

        if ($y> 183) { 
            $pdf->AddPage();
            $y=20;
            $cols=array( 
                "Num" => 10,
                "Cliente" =>84 ,
                "Folio" =>12 ,
                "Serie" =>17 ,
                "Fecha" =>19 ,
                "Forma pago" =>30 ,
                "Moneda" =>13 ,
                "Folio fiscal" =>58 ,
                "Status" =>18
            );
            $pdf->addCols($cols, 10, 20 , 30, $tipoletra, 7, 'B', 0, 0, 0, 0); 
            $y+=8;
            $contador = 1;
            $y1 = $y;
        }  

    }

    $nombre = date("Y-m-dTh-m-s").".pdf"; 
    //$directorio_temp="../../panel/".$datos->empresa_rfc."/cfdi/factura/pdf/".$nombre;
    $directorio_temp="../../panel/".$nombre;

    $pdf->Output("F", $directorio_temp, true);
    $return_arr = array(
            'resultado'   => "I",  
            'documento'   => $directorio_temp  
    );
    echo json_encode($return_arr);
?>
