<?php
    include_once ("../utilerias/algoritmos.php"); 
    include_once ("../utilerias/valida_Receive.php");
    $accion = get_POST("accion"); 

    // Para Insertar
    if ($accion=="Insertar") {
        $razon_social  = get_POST("razon_social"); 
        $rfc  = get_POST("rfc"); 
        $cp  = get_POST("cp"); 
        $regimen  = get_POST("regimen"); 
        insertar_cliente( $razon_social , $rfc , $cp , $regimen  );
    }

    // Para Editar
    if ($accion=="Editar") {
        $id  = get_POST_Required("id");     
        $razon_social  = get_POST("razon_social"); 
        $rfc  = get_POST("rfc"); 
        $cp  = get_POST("cp"); 
        $regimen  = get_POST("regimen"); 
        editar_cliente( $razon_social, $rfc, $cp, $regimen, $id );
    }

    if ($accion == "Eliminar") {
        $id  = get_POST_Required("id"); 
        eliminar_cliente ($id);
    }

    if ($accion == "Duplicado") {
        $campo = get_POST("campo");
        $valor = get_POST("valor");
        get_cliente_Duplicado( $campo, $valor );
    }
    if ($accion == "Reporte"){
        $busquda_array  = array(   
            'razon_social' => array( 'razon_social'=> 'buscar_razon_social', 'tipo'=> 'like') ,
            'rfc' => array( 'rfc'=> 'buscar_rfc', 'tipo'=> 'like') );
        $queryCondition = busca_array_param_joins ( $busquda_array ); 
        get_cliente_JSON($queryCondition);
    }
    if ($accion == "Busqueda"){
        $keyword = get_POST("keyword"); 
        get_cliente_All_combo($keyword);
    }
    if ($accion == "Regimen") {  
        $id     = get_POST("id");  
        get_cliente_regimen( $id );
    }

function insertar_cliente($razon_social , $rfc , $cp , $regimen ){
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

	$registro = SQL_save($pdo, 'cliente', ['razon_social', 'rfc', 'cp', 'regimen'], [ $razon_social, $rfc, $cp, $regimen ]);
    if ($registro > 0)
        $msg = "Ingresado exitosamente";
    else
        $msg = "Error al insertar"; 

    $return_arr = array(
        'resultado'   => $registro, //,
        'msg'         => $msg  
    );
    echo json_encode($return_arr);
    }


    // Función Eliminar
    function eliminar_cliente( $llaveprimaria ){
        include_once ("../utilerias/pdo.php");
        define ("PDO_DEBUG", "3");
        $pdo = SQL_Connect (); 
    
        $condicion = "  where id =  ".$llaveprimaria;
        $registro = SQL_delete($pdo, 'cliente',  $condicion);
    
        $msg = "";
        if ($registro == 0) {
            $msg = "Eliminado exitosamente";
        }

        $return_arr = array(
            'resultado'   => $registro, //,
            'msg'         => $msg  
        );
        echo json_encode($return_arr);
   }

 
function editar_cliente($razon_social, $rfc, $cp, $regimen, $id) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $registro = SQL_update($pdo, 'cliente', [ 'razon_social', 'rfc', 'cp', 'regimen' ], [ $razon_social, $rfc, $cp, $regimen ], "   WHERE id = $id "  ); 

    if ($registro == 0)
        $msg = "Editado exitosamente";
    else
        $msg = "Error al editar";

    $return_arr = array(
        'resultado'   => $registro, //,
        'msg'         => $msg  
    );
    echo json_encode($return_arr);
}

function get_cliente($id) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT A.id, A.razon_social, A.rfc, A.cp, A.regimen, B.nombre AS regimen_nombre 
    FROM  cliente A 
    LEFT JOIN cat_regimenfiscal B ON (A.regimen = B.clave) 
    WHERE A.id = $id LIMIT 1 ";
    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    return $datos;
}

function get_cliente_regimen ( $id ){
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 
     
    $sql    = "SELECT regimen FROM  cliente WHERE id = $id LIMIT 1 ";
    $datos  = SQL_MultiFetch ($pdo, $sql, null);
     $return_arr = array(
        'resultado'   => $datos[0]["regimen"], //,
        'msg'         => "" 
    );     
    echo json_encode($return_arr);
 } 

 function get_cliente_Duplicado( $campo, $valor ){
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT * FROM  cliente WHERE $campo LIKE '$valor' LIMIT 1 ";
    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    // Acá incrusto
    $existe = false;
    if (!empty($datos)) $existe = true;
        $return_arr = array(
        'resultado'   => $existe //, //,
        //'msg'         => $msg  
    );
    echo json_encode($return_arr);
    // Acá incrusté
    //return $datos; 
 }

function get_cliente_All( $condicion ) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT * FROM  cliente WHERE '$condicion' ";
    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    return $datos;
}

function get_cliente_All_combo( $condicion ) { 
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT * FROM  cliente WHERE razon_social LIKE '%$condicion%' ";
    $datos  = SQL_MultiFetch ($pdo, $sql, null);

    if (! empty($datos)) { 
        ?>
<ul id="datos-list">
<?php
        foreach ($datos as $campos) {  
            ?>
    <li   onClick="selectDatos('<?php echo $campos["id"]; ?>',  '<?php echo $campos["razon_social"]; ?>');">
      <?php echo $campos["razon_social"]; ?>
    </li>
<?php
        }// end for
    ?>
</ul>
    <?php
    }// end if not empty

}

// Obtengo los datos del reporte
function get_cliente_JSON( $condicion ) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT  
    A.id, A.razon_social, A.rfc, A.cp, A.regimen, A.fecha_creacion, A.status, B.nombre AS regimen   
    FROM cliente A  
    LEFT JOIN cat_regimenfiscal B ON (A.regimen = B.clave) 
    $condicion ORDER by A.razon_social "; 

    $datos  = SQL_MultiFetch ($pdo, $sql, null);

    $return_arr = array();
    if (!empty($datos)) {
        foreach($datos as $k=>$v) {
            if ($datos[$k]["status"]== "A") $datos[$k]["status"] = "Activo";
            else $datos[$k]["status"] = "Inactivo";  
            
            $return_arr[] = array(
            'id'            => $datos[$k]["id"], 
            'razon_social'  => $datos[$k]["razon_social"], 
            'rfc'           => $datos[$k]["rfc"],
            'cp'            => $datos[$k]["cp"], 
            'regimen'       => $datos[$k]["regimen"],
            'fecha_creacion'=> $datos[$k]["fecha_creacion"],
            'status'        => $datos[$k]["status"]
            );
        }
    }
    echo json_encode($return_arr);
}

?> 
